/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.InternalFrameMenuManager;
import DE.siemens.ad.logo.app.MDIManager;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.ModelFileListener;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.NetworkSimulationManager;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InternalFrameMDIManager
extends MDIManager
implements ModelFileListener {
    protected JDesktopPane fDesktopPane;
    protected Hashtable fWindowViewDictionary;
    protected MenuManager fMenuManager;
    public ActionFactory fActionFactory;
    public ActionManager fActionManager;
    public static final int CASCADE_DISTANCE = 20;
    private InternalFrameEventHandler fInternalFrameEventHandler;
    private WindowEventHandler fWindowEventHandler;

    protected WindowListener getWindowEventHandler() {
        if (this.fWindowEventHandler == null) {
            this.fWindowEventHandler = new WindowEventHandler();
        }
        return this.fWindowEventHandler;
    }

    public void addView(View view) {
        JInternalFrame internalFrame = new JInternalFrame("", true, true, true, true);
        this.fWindowViewDictionary.put(internalFrame, view);
        internalFrame.setDefaultCloseOperation(0);
        internalFrame.setTitle(this.getTitleName(view));
        internalFrame.getContentPane().add(view.getViewComponent());
        this.fDesktopPane.add(internalFrame);
        internalFrame.addInternalFrameListener(this.getInternalFrameEventHandler());
        view.getModel().addModelFileListener(this);
        internalFrame.setFrameIcon(view.getEditor().getEditorInfo().getIcon());
        boolean maximum = true;
        if (this.getActiveTopLevelView() != null) {
            maximum = this.getInternalFrame(this.getActiveTopLevelView()).isMaximum();
        }
        internalFrame.setBounds(this.calculateFrameBounds());
        if (maximum) {
            try {
                internalFrame.setMaximum(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
        internalFrame.show();
        super.addView(view);
    }

    public void arrangeHorizontal() {
        JDesktopPane desktop = this.fDesktopPane;
        JInternalFrame[] frames = desktop.getAllFrames();
        int deskWidth = desktop.getWidth();
        int deskHeight = desktop.getHeight();
        int agentCount = frames.length;
        int frameWidth = deskWidth / agentCount;
        int frameHeight = deskHeight;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setIcon(false);
                frames[i].setMaximum(false);
                frames[i].setVisible(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            frames[i].setBounds(i * frameWidth, 0, frameWidth, frameHeight);
        }
    }

    public void arrangeVertical() {
        JDesktopPane desktop = this.fDesktopPane;
        JInternalFrame[] frames = desktop.getAllFrames();
        int deskWidth = desktop.getWidth();
        int deskHeight = desktop.getHeight();
        int agentCount = frames.length;
        int frameWidth = deskWidth;
        int frameHeight = deskHeight / agentCount;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setIcon(false);
                frames[i].setMaximum(false);
                frames[i].setVisible(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            frames[i].setBounds(0, i * frameHeight, frameWidth, frameHeight);
        }
    }

    private Rectangle calculateFrameBounds() {
        boolean reserved;
        Dimension desktopDimension = this.fDesktopPane.getSize();
        Point point = new Point(0, 0);
        Component[] components = this.fDesktopPane.getComponents();
        do {
            point.translate(10, 10);
            reserved = false;
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].getLocation().equals(point)) continue;
                reserved = true;
            }
        } while (reserved);
        if (point.x > desktopDimension.width - 50 || point.y > desktopDimension.height - 50) {
            point = new Point(desktopDimension.width - 50, desktopDimension.height - 50);
        }
        Dimension dimension = (Dimension)desktopDimension.clone();
        dimension.width -= 10 + point.x;
        dimension.height -= 10 + point.y;
        return new Rectangle(point, dimension);
    }

    public void cascadeFrames() {
        JDesktopPane desktop = this.fDesktopPane;
        JInternalFrame[] frames = desktop.getAllFrames();
        int deskWidth = desktop.getWidth();
        int deskHeight = desktop.getHeight();
        int agentCount = frames.length;
        int frameWidth = deskWidth - (agentCount - 1) * 20;
        int frameHeight = deskHeight - (agentCount - 1) * 20;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[frames.length - i - 1].setIcon(false);
                frames[frames.length - i - 1].setMaximum(false);
                frames[frames.length - i - 1].setVisible(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
            frames[frames.length - i - 1].setBounds(i * 20, i * 20, frameWidth, frameHeight);
        }
    }

    public void changeToView(View view) {
        super.changeToView(view);
        if (view == null || view == this.fActiveTopLevelView) {
            return;
        }
        this.fActiveTopLevelView = view;
        JInternalFrame frame = this.getInternalFrame(view);
        try {
            frame.setIcon(false);
            frame.setSelected(true);
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
        this.fApplicationSurface.setEditor(view.getEditor());
        frame.show();
        frame.setVisible(true);
    }

    public void close() {
        super.close();
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
            this.fActionFactory.setActionPackage("DE.siemens.ad.logo.app.action.");
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    private JInternalFrame getInternalFrame(View view) {
        JInternalFrame internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, view.getViewComponent());
        return internalFrame;
    }

    public JComponent getMDIComponent(View view) {
        return this.fDesktopPane;
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new InternalFrameMenuManager(this);
        }
        return this.fMenuManager;
    }

    public String getName() {
        return Language.getString("mdiManager.internalFrame.name", "Internal frames");
    }

    public JComponent getPreviewPanel() {
        JDesktopPane desktopPane = new JDesktopPane();
        desktopPane.setBackground(Global.BACKGROUND_COLOR_APP);
        String window = Language.getString("mdiManager.window", "Window");
        JInternalFrame internalFrame1 = new JInternalFrame(window + "1", true, true, true, true);
        internalFrame1.setFrameIcon(Global.getIcon("Simulation.gif"));
        internalFrame1.getContentPane().setBackground(Global.BACKGROUND_COLOR);
        internalFrame1.setBounds(10, 10, 200, 150);
        desktopPane.add(internalFrame1);
        internalFrame1.setVisible(true);
        JInternalFrame internalFrame2 = new JInternalFrame(window + "2", true, true, true, true);
        internalFrame2.setFrameIcon(Global.getIcon("Simulation.gif"));
        internalFrame2.getContentPane().setBackground(Global.BACKGROUND_COLOR);
        internalFrame2.setBounds(50, 50, 200, 150);
        desktopPane.add(internalFrame2);
        internalFrame2.setVisible(true);
        internalFrame2.toFront();
        return desktopPane;
    }

    public String getTitleName(View view) {
        return view.getModel().getFile().getPath();
    }

    public void modelFileChanged(Model source, File oldFile, File newFile) {
        Iterator i = this.getViews(source).iterator();
        View v = null;
        while (i.hasNext()) {
            v = (View)i.next();
            JInternalFrame internalFrame = this.getInternalFrame(v);
            internalFrame.setTitle(this.getTitleName(v));
            internalFrame.repaint();
        }
    }

    public void open() {
        this.fDesktopPane = new JDesktopPane();
        this.fDesktopPane.setBackground(Global.BACKGROUND_COLOR_APP);
        this.fWindowViewDictionary = new Hashtable();
        super.open();
    }

    public void removeView(View view) {
        JInternalFrame internalFrame = this.getInternalFrame(view);
        internalFrame.setVisible(false);
        internalFrame.removeInternalFrameListener(this.getInternalFrameEventHandler());
        internalFrame.getContentPane().removeAll();
        this.fDesktopPane.remove(internalFrame);
        this.fDesktopPane.getDesktopManager().closeFrame(internalFrame);
        internalFrame.dispose();
        this.fWindowViewDictionary.remove(internalFrame);
        view.getModel().removeModelFileListener(this);
        super.removeView(view);
        if (this.getViews().isEmpty()) {
            this.fApplicationSurface.setEditor(null);
        } else {
            View v = (View)this.getViews().iterator().next();
            this.changeToView(v);
        }
    }

    public void replaceTopLevelView(View oldView, View newView) {
        if (this.fActiveTopLevelView == oldView) {
            this.fActiveTopLevelView = newView;
        }
        JInternalFrame internalFrame = this.getInternalFrame(oldView);
        int position = this.fViews.indexOf(oldView);
        this.fViews.remove(position);
        this.fViews.insertElementAt(newView, position);
        this.fWindowViewDictionary.remove(internalFrame);
        this.fWindowViewDictionary.put(internalFrame, newView);
    }

    public void setApplicationWindow(ApplicationSurface newApplicationWindow) {
        this.fApplicationSurface = newApplicationWindow;
    }

    protected InternalFrameEventHandler getInternalFrameEventHandler() {
        if (this.fInternalFrameEventHandler == null) {
            this.fInternalFrameEventHandler = new InternalFrameEventHandler();
        }
        return this.fInternalFrameEventHandler;
    }

    public void modelFileSavedStatusChanged(Model model, boolean oldStatus, boolean newStatus) {
        for (View view : this.getViews(model)) {
            if (!(view.getEditor() instanceof LogoComfort)) continue;
            ((LogoComfortStatusLine)((LogoComfort)view.getEditor()).getStatusLine()).setModified(true);
        }
    }

    public void updateSimulatedViewTitle(View view) {
        String ip = ((LogoDrawing)((LogoDrawingView)view).drawing()).getWiringDiagram().getNetworkInfo().getIPAddress();
        JInternalFrame frame = this.getInternalFrame(view);
        String viewName = view.getModel().getFile().getPath();
        if (frame == null) {
            return;
        }
        if (NetworkSimulationManager.getInstance().getSimulationManager(ip) != null) {
            frame.setFrameIcon(Global.getIcon("Network.gif"));
            frame.setTitle(viewName + "(" + ip + ")");
        } else {
            frame.setFrameIcon(Global.getIcon("Simulation.gif"));
            frame.setTitle(viewName);
        }
    }

    public void updateViewTitle(File oldFileInView, File newFileInView) {
        for (View view : this.getViews()) {
            if (!oldFileInView.getPath().equalsIgnoreCase(view.getModel().getFile().getPath())) continue;
            JInternalFrame frame = this.getInternalFrame(view);
            if (frame != null) {
                view.getModel().setFile(newFileInView);
                String newTitle = frame.getTitle().replace(oldFileInView.getName(), newFileInView.getName());
                frame.setTitle(newTitle);
            }
            return;
        }
    }

    protected class InternalFrameEventHandler
    extends InternalFrameAdapter {
        protected InternalFrameEventHandler() {
        }

        public void internalFrameActivated(InternalFrameEvent ive) {
            View view = (View)InternalFrameMDIManager.this.fWindowViewDictionary.get(ive.getSource());
            InternalFrameMDIManager.this.changeToView(view);
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            View view = (View)InternalFrameMDIManager.this.fWindowViewDictionary.get(e.getSource());
            InternalFrameMDIManager.this.getApplication().closeView(view, 2);
        }
    }

    protected class WindowEventHandler
    extends WindowAdapter {
        protected WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            InternalFrameMDIManager.this.fApplication.exit(false);
        }
    }
}

